<?php
include 'constants.php';
include 'admin/portal.php';
include 'admin/mydb.php';

class PortalFront extends Portal
{
  //Tutaj pozostae skadowe klasy
  
  function getNewsHeaders($ile)
  {
    if(!$this->dbo) return false;
    $query = "SELECT Id, Naglowek FROM News ORDER BY Data DESC LIMIT $ile";
    return $this->dbo->query($query);
  }
 
  function getNews()
  {
    if(!$this->dbo) return false;
    
    //Pobranie identyfikatora news
    if(!isset($_GET['newsId'])){
      return false;
    }
    else{
      $newsId = (int) $_GET['newsId'];
    }
    
    //Formowanie zapytania
    $query = "SELECT n.Naglowek, n.Tresc, n.Data, u.Nazwa "
           . "FROM News n INNER JOIN Users u "
           . "ON n.UserId = u.id "
           . "WHERE n.id = $newsId";
    
    if(!$result = $this->dbo->query($query)){
      return false;
    }
    
    //Zwrcenie wyniku
    return $result->fetch_row();
  }
  
  function showNewsList($limit)
  {
    if(!$this->dbo) return false;
    
    //Odczytanie parametru page
    if(isset($_GET['page'])){
      $page = (int) $_GET['page'];
    }
    else{
      $page = 0;
    }
    
    //Okrelenie cakowitej liczby wierszy w tabeli News
    $query = "SELECT COUNT(*) FROM News";
    $rowsCount = (int) $this->dbo->getQuerySingleResult($query);
    
    //Obliczenie cakowitej liczby stron z wynikami
    if($limit != 0){
      $pages = ceil($rowsCount / $limit);
      if($page < 0 || $page >= $pages){
        $page = 0;
      }
      $offset = $page * $limit;
    }
    else{
      $page = 0;
      $pages = 1;
      $offset = 0;
      $limit = $rowsCount;
    }
    
    //Zapytanie pobierajce wyniki dla biecej strony
    $query = "SELECT n.Id, n.Naglowek, n.Data, u.Nazwa "
           . "FROM News n INNER JOIN Users u "
           . "ON n.UserId = u.Id "
           . "ORDER BY Data DESC "
           . "LIMIT $offset, $limit";
    
    $news = $this->dbo->query($query);
    
    include 'templates/newsTemplate.php';
  }
}
?>